/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.CPU6502;
import de.joergjahnke.c64.core.CPU6502Instruction;
import de.joergjahnke.c64.core.VIA6522_BC;
import de.joergjahnke.c64.core.VIA6522_DC;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class C1541CPU6502
extends CPU6502 {
    private static final int OPCODE_DCROUTINE = 2;
    private static final int OPCODE_SKIPROMTEST = 18;
    private static final int OPCODE_WAITLOOP = 34;
    private static final int OPCODE_PRINTFILENAME = 50;
    private static final int OPCODE_FILEWRITE1 = 66;
    private static final int OPCODE_FILEWRITE2 = 82;
    private static final int OPCODE_FILEWRITE3 = 98;
    private static final int RAM_SIZE = 2048;
    private static final int ROM_OFFSET = 2048;
    private static final int FLOPPY_ROM_SIZE = 16384;
    private static final int FLOPPY_ROM_ADDRESS = 49152;
    private static final int FLOPPY_ROM_OFFSET = -47104;
    private static final int BUFFER0_MEMORY = 768;
    private static final int BUFFER0_TRACKSECTOR = 6;
    private static final int JOB_READ_SECTOR = 128;
    private static final int JOB_WRITE_SECTOR = 144;
    private static final int JOB_VERIFY_SECTOR = 160;
    private static final int JOB_SEARCH_SECTOR = 176;
    private static final int JOB_BUMP = 192;
    private static final int JOB_EXECUTE = 208;
    private static final int JOB_EXECUTE_WITH_STARTUP = 224;
    private static final int STATUS_OK = 1;
    private static final int STATUS_BLOCK_NOT_FOUND = 4;
    private static final int STATUS_WRITE_PROTECT = 8;
    private static final int STATUS_NO_DISK = 15;
    private static final int XDI = -1;
    private final C1541 c1541;

    public C1541CPU6502(C1541 c1541) {
        super(c1541, 18432);
        this.ramSize = 2048;
        this.c1541 = c1541;
        this.setLogger(this.c1541.getLogger());
        this.installROMs();
        this.setPC(this.getStartAddress());
    }

    @Override
    protected final int getPC() {
        return this.pc >= 49152 ? this.pc + -47104 : this.pc;
    }

    @Override
    protected final byte readByte(int address) {
        switch (address & 0xF000) {
            case 0: {
                return this.memory[address & 0x7FF];
            }
            case 4096: {
                switch (address & 0xFF00) {
                    case 6144: {
                        return (byte)this.c1541.getVIA(0).readRegister(address & 0xF);
                    }
                    case 7168: {
                        return (byte)this.c1541.getVIA(1).readRegister(address & 0xF);
                    }
                }
                return 0;
            }
            case 49152: 
            case 53248: 
            case 57344: 
            case 61440: {
                return this.memory[-47104 + address];
            }
        }
        return 0;
    }

    @Override
    protected final void writeByte(int address, byte data) {
        block0 : switch (address & 0xF000) {
            case 0: {
                this.memory[address & 0x7FF] = data;
                break;
            }
            case 4096: {
                switch (address & 0xFF00) {
                    case 6144: {
                        this.c1541.getVIA(0).writeRegister(address & 0xF, data & 0xFF);
                        break block0;
                    }
                    case 7168: {
                        this.c1541.getVIA(1).writeRegister(address & 0xF, data & 0xFF);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int i = 0;
        while (i < 2048) {
            this.memory[i] = 0;
            ++i;
        }
        this.setPC(this.getStartAddress());
    }

    protected final void installROMs() {
        this.loadROM("/roms/floppy.c64", 2048, 16384);
    }

    protected void patchROMs() {
        this.addInstruction(new CPU6502Instruction("XI0", 2, -1, 0, 0));
        this.addInstruction(new CPU6502Instruction("XI1", 18, -1, 0, 0));
        this.addInstruction(new CPU6502Instruction("XI2", 34, -1, 0, 0));
        this.addInstruction(new CPU6502Instruction("XI3", 50, -1, 1, 0));
        this.addInstruction(new CPU6502Instruction("XI4", 66, -1, 1, 0));
        this.addInstruction(new CPU6502Instruction("XI5", 82, -1, 1, 0));
        this.addInstruction(new CPU6502Instruction("XI6", 98, -1, 1, 0));
        this.memory[15024] = 2;
        this.memory[13001] = 18;
        this.memory[13311] = 34;
        this.memory[8116] = 50;
        this.memory[15756] = 66;
        this.memory[15779] = 82;
        this.memory[17585] = 98;
        this.memory[17628] = 98;
    }

    @Override
    protected void emulateInstruction(CPU6502Instruction instruction) {
        this.overflowFlag |= ((VIA6522_DC)this.c1541.getVIA(1)).isByteReady();
        super.emulateInstruction(instruction);
    }

    @Override
    protected void emulateExtendedInstruction(CPU6502Instruction instruction) {
        switch (instruction.opCode) {
            case 2: {
                if (!this.c1541.isEmulateDiskController()) {
                    this.emulateDiskControllerIRQRoutine();
                    break;
                }
                this.emulateInstruction(this.getInstruction(186));
                break;
            }
            case 18: {
                this.setPC(60138);
                break;
            }
            case 34: {
                this.emulateInstruction(this.getInstruction(88));
                this.c1541.stop();
                break;
            }
            case 50: {
                this.emulateInstruction(this.getInstruction(165));
                StringBuffer filename = new StringBuffer();
                int i = 512;
                while (i < 528) {
                    if (this.memory[i] <= 0) break;
                    filename.append((char)this.memory[i]);
                    ++i;
                }
                this.getLogger().info("Opening file '" + filename + "'");
                break;
            }
            case 66: {
                ((VIA6522_DC)this.c1541.getVIA(1)).proceedToNextSync();
                this.setPC(62868);
                break;
            }
            case 82: {
                ((VIA6522_DC)this.c1541.getVIA(1)).writeSync();
                this.setPC(62897);
                break;
            }
            case 98: {
                ((VIA6522_DC)this.c1541.getVIA(1)).writeSync();
                this.setPC(this.pc + 11);
                break;
            }
            default: {
                super.emulateExtendedInstruction(instruction);
            }
        }
    }

    protected void emulateDiskControllerIRQRoutine() {
        this.readByte(7172);
        int m = 0;
        while (m < 5) {
            int cmd = this.readByte(m) & 0xF0;
            int track = this.readByte(6 + m * 2) & 0xFF;
            int sector = this.readByte(6 + m * 2 + 1) & 0xFF;
            int bufferAdr = 768 + 256 * m;
            if (cmd > 0) {
                this.c1541.markActive();
            }
            this.writeByte(63, (byte)m);
            switch (cmd) {
                case 128: {
                    this.c1541.getDriveHandler().gotoBlock(track, sector);
                    byte[] bytes = this.c1541.getDriveHandler().readBlock();
                    int i = 0;
                    while (i < bytes.length) {
                        this.writeByte(bufferAdr + i, bytes[i]);
                        ++i;
                    }
                    this.writeByte(76, (byte)sector);
                    this.writeByte(m, (byte)1);
                    break;
                }
                case 144: {
                    this.c1541.getDriveHandler().gotoBlock(track, sector);
                    byte[] bytes = new byte[256];
                    int i = 0;
                    while (i < bytes.length) {
                        bytes[i] = this.readByte(bufferAdr + i);
                        ++i;
                    }
                    this.c1541.getDriveHandler().writeBlock(bytes);
                    this.writeByte(76, (byte)sector);
                    this.writeByte(m, (byte)1);
                    break;
                }
                case 160: 
                case 192: {
                    this.writeByte(m, (byte)1);
                    break;
                }
                case 176: {
                    this.writeByte(34, (byte)track);
                    this.writeByte(67, (byte)DiskDriveHandler.SECTORS_PER_TRACK[track - 1]);
                    this.writeByte(77, (byte)sector);
                    this.writeByte(m, (byte)1);
                    break;
                }
                case 208: 
                case 224: {
                    throw new RuntimeException("Executing jobs not yet implemented!");
                }
            }
            ++m;
        }
        this.setPC(64198);
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeInt(this.irqs.size());
        int i = 0;
        while (i < this.irqs.size()) {
            out.writeUTF(this.irqs.elementAt(i).getClass().getName());
            ++i;
        }
        out.writeInt(this.nmis.size());
        i = 0;
        while (i < this.nmis.size()) {
            out.writeUTF(this.nmis.elementAt(i).getClass().getName());
            ++i;
        }
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        String className;
        super.deserialize(in);
        int size = in.readInt();
        this.irqs.removeAllElements();
        int i = 0;
        while (i < size) {
            className = in.readUTF();
            if (VIA6522_BC.class.getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(0));
            } else if (VIA6522_DC.class.getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(1));
            } else {
                throw new IllegalStateException("Unsupported interrupt type for deserialization: " + className + "!");
            }
            ++i;
        }
        size = in.readInt();
        this.nmis.removeAllElements();
        i = 0;
        while (i < size) {
            className = in.readUTF();
            if (VIA6522_BC.class.getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(0));
            } else if (VIA6522_DC.class.getName().equals(className)) {
                this.irqs.addElement(this.c1541.getVIA(1));
            } else {
                throw new IllegalStateException("Unsupported interrupt type for deserialization: " + className + "!");
            }
            ++i;
        }
    }
}

